use DocumentTools in 

# Application    = NonLinearODEs,
# Component.name = Dial_Input_C3.ms
# Component.type = Dial
#
# Omer Yagel,   07 - Nov - 2009

# Inputs
_C3   := Do(%Dial_Input_C3) ;  # Non Linear Equations Coefficients
_K31  := Do(%Dial_Input_K31);  # Non Linear Equations Coefficients
_N    := Do(%Dial_Input_N)  ;  # Non Linear Equations Coefficients
_A3   := Do(%Dial_Input_A3) ;  # Linear Equations Coefficients
_B3   := Do(%Dial_Input_B3) ;  # Linear Equations Coefficients
_y30  := Do(%Dial_Input_P3) ;  # Initial Conditions
_v30  := Do(%Dial_Input_V3) ;  # Initial Conditions

# Set of Equations
ode1 := diff(y(t), t, t) +  _A3 * (diff(y(t), t)) + _B3  * y(t) = 0  ;
ode2 := diff(y(t), t, t) +  _C3 * (diff(y(t), t)) + _K31 * y(t)^2 = 0  ;
ics  := y(0) = _y30, (D(y))(0) = _v30  ;

# Solving the equations
sol1 := dsolve({ode1, ics}, numeric); 
sol2 := dsolve({ode2, ics}, numeric);

# Plotting generation
p1 := odeplot(sol1, t = 0 .. 10, numpoints = 500, color = blue); 
p2 := odeplot(sol2, t = 0 .. 10, numpoints = 500, color = red) ; 

# Send plots to display
Do( %Plot_ODE3  =  display(p1, p2)  );

end use; 