use DocumentTools in 

# Application    = NonLinearODEs,
# Component.name = Dial_Input_C2.ms
# Component.type = Dial
#
# Omer Yagel,   07 - Nov - 2009


# Inputs
# Non Linear Equations Coefficients
_C2   := Do(%Dial_Input_C2);
_K21  := Do(%Dial_Input_K21);
_K22  := Do(%Dial_Input_K22);

# Linear Equations Coefficients
_A2   := Do(%Dial_Input_A2);
_B2   := Do(%Dial_Input_B2);

# Initial Conditions
_y20  := Do(%Dial_Input_P2);
_v20  := Do(%Dial_Input_V2);

# Set of Equations
ode1 := diff(y(t), t, t) +  _A2*(diff(y(t), t)) + _B2*y(t) = 0  ;
ode2 := diff(y(t), t, t) + (_C2 + _K21*(diff(y(t), t)))*(diff(y(t), t)) + _K22*y(t) = 0  ;
ics  := y(0) = _y20, (D(y))(0) = _v20  ;


# Solving the equations
sol1 := dsolve({ode1, ics}, numeric); 
sol2 := dsolve({ode2, ics}, numeric);


# Plotting generation
p1 := odeplot(sol1, t = 0 .. 10, numpoints = 500, color = blue); 
p2 := odeplot(sol2, t = 0 .. 10, numpoints = 500, color = red); 


# Send plots to display
Do( %Plot_ODE2  =  display(p1, p2)  );


end use; 