use DocumentTools in 

#
# Application    = NonLinearODEs,
# Component.name = Dial_Input_C.ms
# Component.type = Dial
#
# Omer Yagel,   07 - Nov - 2009
#


# Inputs
# Non Linear Equations Coefficients
_C   := Do(%Dial_Input_C);
_K1  := Do(%Dial_Input_K1);
_K2  := Do(%Dial_Input_K2);

# Linear Equations Coefficients
_A   := Do(%Dial_Input_A);
_B   := Do(%Dial_Input_B);

# Initial Conditions
_y0  := Do(%Dial_Input_P);
_v0  := Do(%Dial_Input_V);


# Set of Equations
ode1 := diff(y(t), t, t) + _A*(diff(y(t), t)) + _B*y(t) = 0  ;
ode2 := diff(y(t), t, t) + (_C + _K1*y(t)^2)*(diff(y(t), t)) + _K2*y(t) = 0  ;
ics  := y(0) = _y0, (D(y))(0) = _v0  ;


# Solving the equations
sol1 := dsolve({ode1, ics}, numeric); 
sol2 := dsolve({ode2, ics}, numeric);


# Plotting generation
p1 := odeplot(sol1, t = 0 .. 10, numpoints = 500, color = blue); 
p2 := odeplot(sol2, t = 0 .. 10, numpoints = 500, color = red); 


# Send plots to display
Do( %Plot_ODE  =  display(p1, p2)  );


end use; 