use DocumentTools in 

#
# Application    = 2nd order ODE-nonlinear dumping,
# Component.name = Dial
# Component.type = Dial
#
# Omer Yagel,   22 - Nov - 2009
#


#
# Inputs
#
_K1  := Do(%Dial_Comp_Dumping);
_K2  := Do(%Dial_Reb_Dumping);
_K3  := Do(%Dial_ICS_Location);
_K4  := Do(%Dial_ICS_Velocity);


#
# Definitions
#
C_avr := (_K1 + _K2) /2 ;
b     := piecewise(x < 0, _K2, x > 0, _K1) ;
ics   := y(0) = _K3, (D(y))(0) = _K4 ;

# Equations
ode1 := diff(y(x), x, x)+(1/4)*C_avr*(diff(y(x), x))+10*y(x) = 0;
ode2 := diff(y(x), x, x)+(1/4)*  b  *(diff(y(x), x))+10*y(x) = 0;

# Solutions
sol1 := dsolve({ics, ode1}, numeric, output = listprocedure);
sol2 := dsolve({ics, ode2}, numeric, output = listprocedure);

# Plots
P1 := plots[odeplot](sol1, x = 0 .. 10, numpoints = 1000, color = blue) ; 
P2 := plots[odeplot](sol2, x = 0 .. 10, numpoints = 1000, color = red)  ; 



Do( %Plot0 = display(P1, P2) );

end use; 

